package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Comparator;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "documentreviewnote", schema = "hib")
public class DocumentReviewNote extends BusinessObject {

	@JoinColumn(name = "documentid")
	@ManyToOne(fetch = FetchType.LAZY)
	private Document document;

	@JoinColumn(name = "roleid")
	@ManyToOne(fetch = FetchType.LAZY)
	private Group group;

	@Column(name="text", columnDefinition = "varchar(max)")
	private String text;
	
	DocumentReviewNote(){}
	
	public static DocumentReviewNote create(final Document document, final String text, final String createdBy, final Group group) throws ValidationException {
		
		ValidationHelper.required("Group", group);
		ValidationHelper.required("Document", document);
		ValidationHelper.required("Note Text", text);
		ValidationHelper.required("Created By", createdBy);
		
		DocumentReviewNote result = new DocumentReviewNote();
		
		result.name = "review note";
		result.createdBy = createdBy;
		result.createdOn = new Date();
		result.group = group;
		result.document = document;
		result.text = text;
		
		DartObjectFactory.getInstance().getDocumentReviewNoteDAO().save(result);
		
		return result;
	}
	

	public static List<DocumentReviewNote> listByGroupId(final int documentId, final int groupId) {
		return DartObjectFactory.getInstance().getDocumentReviewNoteDAO().listByGroupId(documentId, groupId);
	}
	
	public static List<DocumentReviewNote> listByReviewerAndDoc(final String reviewerLoginId, final int documentId, final int groupId) {
		return DartObjectFactory.getInstance().getDocumentReviewNoteDAO().listByReviewerId(reviewerLoginId, documentId, groupId);
	}

	public static DocumentReviewNote findById(final int documentId, final String createdBy) {
		return DartObjectFactory.getInstance().getDocumentReviewNoteDAO().findById(documentId, createdBy);
	}
	
	public static List<DocumentReviewNote> listByReviewerId(final String createdBy, final int documentId, final int groupId) {
		return DartObjectFactory.getInstance().getDocumentReviewNoteDAO().listByReviewerId(createdBy, documentId, groupId);
	}

	public static List<DocumentReviewNote> listByGroupIdForDocumentVersions(final int documentHeadId, final int groupId) {
		return DartObjectFactory.getInstance().getDocumentReviewNoteDAO().listByGroupIdForDocumentVersions(documentHeadId, groupId);
	}
	
	public static int countDocumentVersions(final int documentHeadId, final int groupId) {
		return DartObjectFactory.getInstance().getDocumentReviewNoteDAO().countDocumentVersions(documentHeadId, groupId);
	}

//	public static List<DocumentReviewNote> listByGroupIdForRequestAndDocumentContent(final int requestId, final int documentId, final int contentId, final int groupId) {
//		return DartObjectFactory.getInstance().getDocumentReviewNoteDAO().listByGroupIdForRequestAndDocumentContent(requestId, documentId, contentId, groupId);
//	}	
	
	public static Integer countNotesForActiveLocationDocsAndGroupId(final int requestHeadId, final int locationId, final int groupId) {
		return DartObjectFactory.getInstance().getDocumentReviewNoteDAO().countNotesForActiveLocationDocsAndGroupId(requestHeadId, locationId, groupId);
	}

	public static Integer countNotesForActiveParticipantDocsAndGroupId(final int requestHeadId, final int participantId, final int groupId) {
		return DartObjectFactory.getInstance().getDocumentReviewNoteDAO().countNotesForActiveParticipantDocsAndGroupId(requestHeadId, participantId, groupId);
	}

	
	public Document getDocument() {
		return document;
	}

	public String getText() {
		return text;
	}

	public Group getGroup() {
		return group;
	}
	
	
	@Override 
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof DocumentReviewNote) == false) {	//may want to use isAssignableFrom()
			return false;
		}
		
		return this.getId() == ((DocumentReviewNote)obj).getId();	//compare the id column
	}
	
	
	/** Get a comparator for sorting a list of DocumentReviewNotes by date created, descending.
	 * 
	 * @return
	 */
	public static Comparator<DocumentReviewNote> getDescCreatedOnComparator() {
		return new Comparator<DocumentReviewNote>() {

			@Override
			public int compare(DocumentReviewNote o1, DocumentReviewNote o2) {
				if (o1 == null && o2 == null) {
					return 0;
				}
				
				if (o1.createdOn == null) {
					if (o2.createdOn == null) {
						return 0;
					}
					else {
						return 1;	//descending sort
					}
				}
				else {
					if (o2.createdOn == null) {
						return -1;	//descending sort
					}
				}
				
				return o2.createdOn.compareTo( o1.createdOn );	//descending sort
			}
		};
	}
	
}
